////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////// Effects of Economic Crises and IMF Programs on Gender Inequality: Primal School Enrollment Rate //////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//start
clear all
local path R:\Reina\Replication_Gender_July13\IMFWP_ResCover_Additional
cd "`path'"


local genvar "Prim_Enr_GPI"  
local covar1 "ResMoImp" 


capture log close
log using `genvar'22allyrs_log.log, replace

save Temp_Treated_Program_Countries, emptyok replace
save "All_pvals_`genvar'22allyrs_Final.dta", emptyok replace

local covar1 "ResMoImp" // vars that enter regression with several lags and must be specified blow in the allsynth command
local initial = 1
 
/*
local genvar "Ad_Fert_R" 98
local genvar "Prim_Enr_GPI" 50
local genvar "Sec_Enr_GPI" 24
local genvar "Tert_Enr_GPI" 
local genvar "GE" 58
local genvar "LFPR_Fem_ILO" 58

*/

forval progyr = 2019/2021{
	use merged_paneldata_mod_1008, clear
	local window = 4
	local start = `progyr'-`window'
	*local end = `progyr'+`window'
	if `progyr' == 2019 {
    local end = `progyr' + `window' - 1
	}
	else if `progyr' == 2020 {
    local end = `progyr' + `window' - 2
	}
	else if `progyr' == 2021 {
    local end = `progyr' + `window' - 3
	}		
	drop if year > `end' | year < `start'

	// Which countries did not have program_news before progyr
	forval v=1/`window'{
	drop if program_new == 1 & year ==  `start' -1 + `v'
	}
	
	// Which countries have balanced panel?
	tsset countrycode year
	xtbalance, range(`start' `end') miss(`genvar' `covar1') 
	
	// Of these, how many had a program_new in progyr?
	keep if program_new == 1 & year == `progyr' 
	order Country countrycode income_level year program_new `dependent' `covar1'
	append using Temp_Treated_Program_Countries //start with empty GE_estimate file
	save Temp_Treated_Program_Countries, replace
	}
sort Country year
unique countrycode year // good to check here whats going on to see sample size
export excel using "CandidatesWithData_`genvar'22allyrs.xlsx", firstrow(variables) replace
erase Temp_Treated_Program_Countries.dta

//////////////////////////////////////////////////////////////////////////////////////////  
//////////////////////////////////////////////////////////////////////////////////////////  
// File A_ID_Number_Of_TREATED_PROG_COUNTRIES_v1.do produces countries with a) progs in progyr (or later) b) balanced panel 
// This File prepares the dataset for synth runs, runs synth and saves pvalues for 
//////////////////////////////////////////////////////////////////////////////////////////
/*
local genvar "Ad_Fert_R" 98
local genvar "Prim_Enr_GPI" 50
local genvar "Sec_Enr_GPI" 24
local genvar "Tert_Enr_GPI" 
local genvar "GE" 58
local genvar "LFPR_Fem_ILO" 58
*/

*import excel "C:\Users\te\OneDrive - UW\Monique gender\data_output\CandidatesWithData_`genvar'.xlsx", sheet("Sheet1") firstrow clear
import excel "CandidatesWithData_`genvar'22allyrs.xlsx", sheet("Sheet1") firstrow clear

keep year countrycode income_level
tostring income_level, replace
save output_`genvar'22allyrs.dta, replace

*use "C:\Users\te\OneDrive - UW\Monique gender\data_output\merged_paneldata_mod_v2.dta" , clear
use "merged_paneldata_mod_1008.dta" , clear
merge 1:1 countrycode year using output_`genvar'22allyrs

bysort _merge: gen row = _n 
replace row = . if _merge == 1
sort row

count if !missing(row)
local obs_count = r(N)

*save "C:\Users\te\OneDrive - UW\Monique gender\data_output\merged_paneldata_mod_v2_xls_added_`genvar'_final.dta" , replace
save "merged_paneldata_mod_1008_xls_added_`genvar'22allyrs_final.dta" , replace
                 
/////////////// PROGRAM START////////////////////////////////////
//////////////// take progyr and cc and income_level from xls file
//////////////////////////////////////////////////////////////////

forvalues i = `initial'/`obs_count' {               

use "merged_paneldata_mod_1008_xls_added_`genvar'22allyrs_final.dta" , clear
*sort countrycode year

quiet summarize year in `i'
local progyr  = r(mean)
display "program_new year = `progyr'"

quiet summarize countrycode in `i'
local cc  = r(mean)
display "countrycode = `cc'"

display "obs_count = `i'"

display "Tot Nr Prog = `obs_count'"

local window = 4
local start = `progyr'-`window'
*local end = `progyr'+`window'
	if `progyr' == 2019 {
    local end = `progyr' + `window' - 1
	}
	else if `progyr' == 2020 {
    local end = `progyr' + `window' - 2
	}
	else if `progyr' == 2021 {
    local end = `progyr' + `window' - 3
	}		
drop if year > `end' | year < `start'

// Cannot have any other countries that had program_news from start to end
drop if program_new == 1 & countrycode != `cc'

///////////////////////////////////////////////////////////////////////////////////////
*High income prog country?
// countries are income_level H, L, M etc              <------------------  
// if country is H then do not drop it or any other H country 
// if country is not H, then drop all other H countries from the sample
quietly count if (countrycode == `cc' & income_level!= "H" & year == `progyr')
local yes = r(N)
di "`yes'"
if `yes' > 0 {
  drop if income_level == "H" // If there exists an observation with countrycode == `cc' & income_level != H, drop all H countries
}

// balance panel 
tsset countrycode year
xtbalance, range(`start' `end') miss(`genvar' `covar1') 

// associate IMFcode with ISO3 country code
kountry countrycode, from(imfn)

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Now Run Allsynth Command. (Allsynth builds on both "Synth" and "Synthrunner" and bias corrects (that is generated by imperfect match)
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
forval v=1/`window'{
	local n`v' = `progyr'-`window'-1+`v'
}

    capture noisily{
allsynth `genvar'  `genvar'(`n2') `genvar'(`n3') `genvar'(`n4')  ResMoImp(`n4') ResMoImp(`n3') ResMoImp(`n2') ResMoImp(`n1'), trunit(`cc') trperiod(`progyr') unitnames(NAMES_STD) keep("`cc'_`progyr'_`genvar'22all_PredBal.dta") replace bcorrect(merge) pvalues(rmspe) 

}

 if _rc != 0 {
    continue //, break or any other action you want to take when `genvar` does not exist
}


capture use `cc'_`progyr'_`genvar'22all_PredBal.dta, clear
capture keep if countrycode == `cc'
capture ren _time year  
 

capture append using "All_pvals_`genvar'22allyrs_Final.dta"

save "All_pvals_`genvar'22allyrs_Final.dta", replace
}



use "All_pvals_`genvar'22allyrs_Final.dta" , replace

*kountry countrycode, from(imfn)
ren NAMES_STD countryname
drop if rmspe == .
unique countrycode
order countryname countrycode year p_bc gap_bc

drop if p_bc > .1
unique countrycode

kountry countrycode, from(imfn)
order countryname countrycode year p_bc gap_bc

save "All_pvals_`genvar'22allyrs_Final_sig.dta", replace


// save all outcomes ready for xls file
use "All_pvals_`genvar'22allyrs_Final.dta" , replace

*kountry countrycode, from(imfn)
rename NAMES_STD countryname 
drop if unique_W == 0
keep countryname year _Y_treated gap_bc p_bc N unique_W
order countryname year _Y_treated gap_bc p_bc N unique_W
export excel using "`path'\Result_Summary`genvar'22allyrs", sheet("`genvar'_22all") sheetmodify firstrow(variables)

log close
